<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest;

use Twilio\Domain;
use Twilio\Exceptions\TwilioException;
use Twilio\Rest\IpMessaging\V1;
use Twilio\Rest\IpMessaging\V2;

/**
 * @property \Twilio\Rest\IpMessaging\V1 $v1
 * @property \Twilio\Rest\IpMessaging\V2 $v2
 * @property \Twilio\Rest\IpMessaging\V2\CredentialList $credentials
 * @property \Twilio\Rest\IpMessaging\V2\ServiceList $services
 * @method \Twilio\Rest\IpMessaging\V2\CredentialContext credentials(string $sid)
 * @method \Twilio\Rest\IpMessaging\V2\ServiceContext services(string $sid)
 */
class IpMessaging extends Domain {
    protected $_v1;
    protected $_v2;

    /**
     * Construct the IpMessaging Domain
     *
     * @param Client $client Client to communicate with Twilio
     */
    public function __construct(Client $client) {
        parent::__construct($client);

        $this->baseUrl = 'https://chat.twilio.com';
    }

    /**
     * @return V1 Version v1 of ip_messaging
     */
    protected function getV1(): V1 {
        if (!$this->_v1) {
            $this->_v1 = new V1($this);
        }
        return $this->_v1;
    }

    /**
     * @return V2 Version v2 of ip_messaging
     */
    protected function getV2(): V2 {
        if (!$this->_v2) {
            $this->_v2 = new V2($this);
        }
        return $this->_v2;
    }

    /**
     * Magic getter to lazy load version
     *
     * @param string $name Version to return
     * @return \Twilio\Version The requested version
     * @throws TwilioException For unknown versions
     */
    public function __get(string $name) {
        $method = 'get' . \ucfirst($name);
        if (\method_exists($this, $method)) {
            return $this->$method();
        }

        throw new TwilioException('Unknown version ' . $name);
    }

    /**
     * Magic caller to get resource contexts
     *
     * @param string $name Resource to return
     * @param array $arguments Context parameters
     * @return \Twilio\InstanceContext The requested resource context
     * @throws TwilioException For unknown resource
     */
    public function __call(string $name, array $arguments) {
        $method = 'context' . \ucfirst($name);
        if (\method_exists($this, $method)) {
            return \call_user_func_array([$this, $method], $arguments);
        }

        throw new TwilioException('Unknown context ' . $name);
    }

    protected function getCredentials(): \Twilio\Rest\IpMessaging\V2\CredentialList {
        return $this->v2->credentials;
    }

    /**
     * @param string $sid The SID of the Credential resource to fetch
     */
    protected function contextCredentials(string $sid): \Twilio\Rest\IpMessaging\V2\CredentialContext {
        return $this->v2->credentials($sid);
    }

    protected function getServices(): \Twilio\Rest\IpMessaging\V2\ServiceList {
        return $this->v2->services;
    }

    /**
     * @param string $sid The SID of the Service resource to fetch
     */
    protected function contextServices(string $sid): \Twilio\Rest\IpMessaging\V2\ServiceContext {
        return $this->v2->services($sid);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        return '[Twilio.IpMessaging]';
    }
}