<?php
namespace QuickBooksOnline\API\Data;

/**
 * @xmlNamespace http://schema.intuit.com/finance/v3
 * @xmlType
 * @xmlName IPPOtherPrefs
 * @var IPPOtherPrefs
 * @xmlDefinition Any other preference not covered in base is covered
                as name value pair, for detailed explanation look at the document

 */
class IPPOtherPrefs
{

        /**
        * Initializes this object, optionally with pre-defined property values
        *
        * Initializes this object and it's property members, using the dictionary
        * of key/value pairs passed as an optional argument.
        *
        * @param dictionary $keyValInitializers key/value pairs to be populated into object's properties
        * @param boolean $verbose specifies whether object should echo warnings
        */
    public function __construct($keyValInitializers = array(), $verbose = false)
    {
        foreach ($keyValInitializers as $initPropName => $initPropVal) {
            if (property_exists('IPPOtherPrefs', $initPropName) || property_exists('QuickBooksOnline\API\Data\IPPOtherPrefs', $initPropName)) {
                $this->{$initPropName} = $initPropVal;
            } else {
                if ($verbose) {
                    echo "Property does not exist ($initPropName) in class (".get_class($this).")";
                }
            }
        }
    }

    
    /**
     * @Definition  Specifies extension of Preference entity to
                        allow extension of Name-Value pair based extension at the top
                        level

     * @xmlType element
     * @xmlNamespace http://schema.intuit.com/finance/v3
     * @xmlMinOccurs 0
     * @xmlMaxOccurs unbounded
     * @xmlName NameValue
     * @var com\intuit\schema\finance\v3\IPPNameValue
     */
    public $NameValue;
} // end class IPPOtherPrefs
